/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker;

import club.sk1er.modcore.ModCoreInstaller;
import club.sk1er.patcher.Patcher;
import club.sk1er.patcher.tweaker.ClassTransformer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@IFMLLoadingPlugin.MCVersion(value="1.8.9")
public class PatcherTweaker
implements IFMLLoadingPlugin {
    public static long clientLoadTime;

    public PatcherTweaker() {
        clientLoadTime = System.currentTimeMillis();
        this.createSecondTweaker();
        this.unlockLwjgl();
        this.detectIncompatibleMods();
    }

    public String[] getASMTransformerClass() {
        int initialize = ModCoreInstaller.initialize(Launch.minecraftHome, "1.8.9");
        if (ModCoreInstaller.isErrored() || initialize != 0 && initialize != -1) {
            System.out.println("Failed to load Sk1er Modcore - " + initialize + " - " + ModCoreInstaller.getError());
        }
        if (ModCoreInstaller.isIsRunningModCore()) {
            return new String[]{"club.sk1er.mods.core.forge.ClassTransformer", ClassTransformer.class.getName()};
        }
        return new String[]{ClassTransformer.class.getName()};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    private void createSecondTweaker() {
        try {
            FMLLaunchHandler launchHandler = (FMLLaunchHandler)ReflectionHelper.getPrivateValue(FMLLaunchHandler.class, null, (String[])new String[]{"INSTANCE"});
            LaunchClassLoader classLoader = (LaunchClassLoader)ReflectionHelper.getPrivateValue(FMLLaunchHandler.class, (Object)launchHandler, (String[])new String[]{"classLoader"});
            Method loadCoreMod = ReflectionHelper.findMethod(CoreModManager.class, null, (String[])new String[]{"loadCoreMod"}, (Class[])new Class[]{LaunchClassLoader.class, String.class, File.class});
            URL path = Patcher.class.getProtectionDomain().getCodeSource().getLocation();
            File mod = new File(path.toURI().getSchemeSpecificPart().split("!")[0]);
            loadCoreMod.invoke(null, classLoader, "club.sk1er.patcher.tweaker.other.ModTweaker", mod);
        }
        catch (Exception e) {
            System.out.println("Failed creating a second tweaker");
        }
    }

    private void unlockLwjgl() {
        boolean lwjglUnlock = false;
        try {
            Field transformerExceptions = LaunchClassLoader.class.getDeclaredField("classLoaderExceptions");
            transformerExceptions.setAccessible(true);
            Object o = transformerExceptions.get(Launch.classLoader);
            lwjglUnlock = ((Set)o).remove("org.lwjgl.");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        if (!lwjglUnlock) {
            System.out.println("Failed to unlock LWJGL, several fixes will not work.");
        }
    }

    private void detectIncompatibleMods() {
        File[] coreModList;
        File mods = new File(Launch.minecraftHome, "mods");
        if (!mods.exists()) {
            mods.mkdirs();
        }
        for (File file : coreModList = mods.listFiles((dir, name) -> name.endsWith(".jar"))) {
            try (ZipFile zipFile = new ZipFile(file);){
                ZipEntry entry = zipFile.getEntry("mcmod.info");
                if (zipFile.getEntry("io/framesplus/FramesPlus.class") != null) {
                    this.halt("Patcher is no longer compatible with Frames+ as of 1.3. The Frames+ enhancements have been rewritten for even greater performance and compatibility, and are now included in Patcher.");
                    continue;
                }
                if (zipFile.getEntry("club/sk1er/mods/core/ModCore.class") != null) {
                    this.halt("ModCore should not be in your mods folder. This will cause issues and most likely crash. Please remove it from the mods folder.");
                    continue;
                }
                if (entry == null) continue;
                try (InputStream inputStream = zipFile.getInputStream(entry);){
                    String modId;
                    byte[] availableBytes = new byte[inputStream.available()];
                    inputStream.read(availableBytes, 0, inputStream.available());
                    JsonObject modInfo = new JsonParser().parse(new String(availableBytes)).getAsJsonArray().get(0).getAsJsonObject();
                    if (!modInfo.has("modid") || !(modId = modInfo.get("modid").getAsString()).equals("the5zigMod") || !modInfo.has("url") || modInfo.get("url").getAsString().equalsIgnoreCase("https://5zigreborn.eu")) continue;
                    this.halt("<html><p>Patcher is not compatible with old 5zig. Please use 5zig reborn found at <a href=\"https://5zigreborn.eu\">https://5zigreborn.eu</a></p></html>");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void halt(String message) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JOptionPane.showMessageDialog(null, message, "Launch Aborted", 0);
        try {
            Class<?> aClass = Class.forName("java.lang.Shutdown");
            Method exit = aClass.getDeclaredMethod("exit", Integer.TYPE);
            exit.setAccessible(true);
            exit.invoke(null, 0);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

